class HUD_MH extends ChallengeHUD;//MonsterHUD

#exec TEXTURE IMPORT NAME=Icon_Ammo FILE=Textures\ammo_icon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Monster FILE=Textures\monster_icon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Player FILE=Textures\player_icon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Health FILE=Textures\health_icon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Shield FILE=Textures\shield_icon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=ut4ever FILE=Textures\ut4everorg.bmp Group=HUD MIPS=ON

//Radar Textures:
#exec Texture Import File=Textures\Radar.bmp Name=Radar Group=RadarBase Maps=Off Flags=2
#exec Texture Import File=Textures\RadarBorder.bmp Name=RadarBorder Group=RadarBase Maps=Off Flags=2
#exec Texture Import File=Textures\Dots.bmp Name=Dots Group=RadarBase Maps=Off Flags=2
#exec Texture Import File=Textures\crossm.bmp Name=crossm Group=RadarBase Maps=Off Flags=2

var int DrawTime;
var color LogoColor,RadarColor;
var float LastDrawRadar, RadarScale, RadarPosX, RadarPosY, RadarPulse;

simulated function DrawMonsterName(Canvas C)
{
	
local float Dist, XN, YN, YNOffset, XL,YL;
local ScriptedPawn P;
local int XPos, YPos;
local Vector X,Y,Z, Dir;
local PlayerPawn PP;

	GetAxes(Owner.Rotation, X, Y, Z);
	
	C.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'ScriptedPawn', P, 1500, Owner.Location, true)//2000
		{
		Dir = P.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		if ((Dir Dot X) > 0.7)
			{
			if ( Dist > 1000 )
				C.Font = MyFonts.GetSmallestFont( C.ClipX );
			else if ( Dist > 750 )
				C.Font = MyFonts.GetSmallFont( C.ClipX );
			else if ( Dist > 500 )
				C.Font = MyFonts.GetMediumFont( C.ClipX );
			else if ( Dist > 250 )
				C.Font = MyFonts.GetBigFont( C.ClipX );
			else
				C.Font = MyFonts.GetHugeFont( C.ClipX );
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.StrLen(P.class.Name$"("$P.Health$")", XL, YL);
			if ( Xpos < 0 )
				Xpos = 0;
			else if ( Xpos > C.ClipX - XL )
				Xpos = C.ClipX - XL;
			C.SetPos(Xpos , YPos );
			C.DrawText(P.class.Name$"("$P.Health$")", true);
			}
		}
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
//Used to draw health and armor:
local Inventory Inv;
local int ArmorAmount, ShieldAmount;

	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if (Inv.bIsAnArmor) 
			{
			if ( Inv.IsA('UT_Shieldbelt') || Inv.IsA('Shieldbelt') )
				{
				ShieldAmount += Inv.Charge;
				}
			else
				{
				ArmorAmount += Inv.Charge;
				}
			}
		}

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 120, -10);
	Canvas.DrawTile(Texture'Icon_Health', 128, 128, 0, 0, 128, 128);
	Canvas.SetPos(Canvas.ClipX - 118, 118);
	Canvas.DrawTile(Texture'Icon_Shield', 128, 128, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	if ( PlayerPawn(Owner).Health > 74 )
		Canvas.DrawColor = GreenColor;
	else if ( PlayerPawn(Owner).Health > 30 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = RedColor;
	DrawBigNum(Canvas, PlayerPawn(Owner).Health, Canvas.ClipX - 76, 80, 0.75);

	if ( ArmorAmount + ShieldAmount > 74 )
		Canvas.DrawColor = GreenColor;
	else if ( ArmorAmount + ShieldAmount > 30 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = RedColor;
	DrawBigNum(Canvas, ArmorAmount + ShieldAmount, Canvas.ClipX - 84, 208, 0.75);
}

simulated function DrawWeapons(Canvas Canvas)
{
//Used to draw monsters:

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY - 128);
	Canvas.DrawTile(Texture'Icon_Monster', 128, 128, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = RedColor;
	DrawBigNum(Canvas, MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).Monsters, Canvas.ClipX - 84, Canvas.ClipY - 40, 0.75);

}

simulated function DrawAmmo(Canvas Canvas)
{
//Used to draw players:

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY - 256);
	Canvas.DrawTile(Texture'Icon_Player', 128, 128, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = GreenColor;
	DrawBigNum(Canvas, MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).Hunters, Canvas.ClipX - 84, Canvas.ClipY - 168, 0.75);
}

simulated function DrawStatus(Canvas Canvas)
{
//Used to draw Ammo now

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Canvas.ClipY - 64);
	Canvas.DrawTile(Texture'Icon_Ammo', 64, 64, 0, 0, 64, 64);

	if ( (PawnOwner.Weapon == None) || (PawnOwner.Weapon.AmmoType == None) )
		return;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = RedColor;
	DrawBigNum(Canvas, PawnOwner.Weapon.AmmoType.AmmoAmount, Canvas.ClipX * 0.5 - 26, Canvas.ClipY - 40, 0.75);
}

simulated function DrawFragCount(Canvas Canvas)
{
local float XL, YL;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen("0123456789", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Score:"@int(PawnOwner.PlayerReplicationInfo.Score));
}

simulated function DrawBigNum(Canvas Canvas, int Value, int X, int Y, optional float ScaleFactor)
{
	local int d, Mag, Step;
	local float UpScale;
	local byte bMinus;

	if ( ScaleFactor != 0 )
		UpScale = Scale * ScaleFactor;
	else
		UpScale = Scale;

	Canvas.CurX = X;	
	Canvas.CurY = Y;
	Step = 16 * UpScale;
	if ( Value < 0 )
		bMinus = 1;
	Mag = FMin(999999999, Abs(Value));

	if ( Mag >= 1000 )
	{
		Canvas.CurX -= Step;
		d = 0.001 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 1000 * d;
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else if ( Mag >= 100 )
	{
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else
		Canvas.CurX += Step;

	if ( Mag >= 10 )
	{
		d = 0.1 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 10 * d;
	}
	else if ( d > 0 )
		DrawDigit(Canvas, 0, Step, UpScale, bMinus);
	else
		Canvas.CurX += Step;

	DrawDigit(Canvas, Mag, Step, UpScale, bMinus);
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

simulated function PostRender( canvas Canvas )
{
	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( DrawTime > 0 || LogoColor.R > 0)
		{
		RenderLogo(Canvas);
		DrawTime--;
		if ( DrawTime < 0 )
			{
			LogoColor.R -= 1;
			}
		}

	Canvas.bNoSmooth = False;
	ShowRaderBase(Canvas);
	ShowRadar(Canvas);
	Canvas.bNoSmooth = True;

	DrawMonsterName(Canvas);
	DrawFragCount(Canvas);
	DrawStatus(Canvas);
	DrawAmmo(Canvas);
	DrawWeapons(Canvas);
	DrawGameSynopsis(Canvas);

	super.PostRender(Canvas);
}

simulated function RenderLogo(Canvas Canvas)
{
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = LogoColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 64);
	Canvas.DrawTile(Texture'ut4ever', 512, 128, 0, 0, 512, 128);
}

simulated function ShowRaderBase(Canvas C) 
{
	
	local float RadarWidth, PulseWidth, PulseBrightness;
	
	RadarScale = Default.RadarScale * 0.5;
	RadarWidth = 0.5 * RadarScale * C.ClipX;
	PulseWidth = RadarScale * C.ClipX;
	C.DrawColor = RadarColor;
	C.Style = ERenderStyle.STY_Translucent;
	
	PulseBrightness = FMax(0,(1 - 2*RadarPulse) * 255.0);
	C.DrawColor.R = PulseBrightness;
	C.DrawColor.G = PulseBrightness;
	C.DrawColor.B = PulseBrightness;
	C.SetPos(RadarPosX*C.ClipX - 0.5*PulseWidth,RadarPosY*C.ClipY+RadarWidth-0.5*PulseWidth);
	C.DrawTile(Texture'Radar', PulseWidth, PulseWidth, 0, 0, 142, 142);
	
	PulseWidth = RadarPulse * RadarScale * C.ClipX;
	C.DrawColor = RadarColor;
	C.SetPos(RadarPosX*C.ClipX - 0.5*PulseWidth,RadarPosY*C.ClipY+RadarWidth-0.5*PulseWidth);
	C.DrawTile(Texture'Radar', PulseWidth, PulseWidth, 0, 0, 142, 142);
	
	C.DrawColor = WhiteColor;
	C.SetPos(RadarPosX*C.ClipX - RadarWidth,RadarPosY*C.ClipY);
	C.DrawTile(Texture'RadarBorder', RadarWidth*2, RadarWidth*2, 0, 0, 142, 142);
}

simulated function ShowRadar(Canvas C) 
{
	
	local Pawn P;
	local float Dist, MaxDist, RadarWidth, PulseBrightness, Angle, DotSize, OffsetY, OffsetScale;
	local rotator Dir;
	local vector Start;
	
	LastDrawRadar = Level.TimeSeconds;
	RadarWidth = 0.5 * RadarScale * C.ClipX;
	DotSize = 20 * C.ClipX /1600;//24
	if (PawnOwner == None)
		Start = PlayerOwner.Location;
	else
		Start = PawnOwner.Location;
	
	MaxDist = 3000 * RadarPulse;
	//C.Style = ERenderStyle.STY_Translucent;
	OffsetY = RadarPosY + RadarWidth / C.ClipY;
	
	foreach AllActors(class'Pawn', P)
		if (P.Health > 0 && (P.IsA('ScriptedPawn') || P.IsA('Bot') || P.IsA('TournamentPlayer')))
                        {
			
			Dist = VSize(Start - P.Location);
			if (Dist < 3000) {
				if (Dist < MaxDist)
					PulseBrightness = 255 - 255 * Abs(Dist*0.00033 - RadarPulse);
				else
					PulseBrightness = 255 - 255 * Abs(Dist*0.00033 - RadarPulse - 1);
				if (P.IsA('ScriptedPawn')) 
                                {
					C.DrawColor.R = PulseBrightness;
					C.DrawColor.G = 0;
					//C.DrawColor.G = PulseBrightness;
					C.DrawColor.B = 0;
				} 
                                else if (P.IsA('Bot') || P.IsA('TournamentPlayer')) 
                                {
					C.DrawColor.R = 0;
					C.DrawColor.B = 0;
					C.DrawColor.G = PulseBrightness;
				}
				Dir = rotator(P.Location - Start);
				OffsetScale = RadarScale * Dist * 0.000167;
				Angle = ((Dir.Yaw - PlayerOwner.Rotation.Yaw) & 65535) * 6.2832 / 65536;
				C.SetPos(RadarPosX * C.ClipX + OffsetScale * C.ClipX * sin(Angle) - 0.5 * DotSize,
					OffsetY * C.ClipY - OffsetScale * C.ClipY * cos(Angle) - 0.5 * DotSize);
				C.DrawTile(Texture'Dots', DotSize, DotSize, 0, 0, 16, 16);
			}
		}            
}

simulated function Tick(float DT) 
{
	local Pawn P;
	
	Super.Tick(DT);
	
	RadarPulse = RadarPulse + 0.5 * DT;
	if (RadarPulse >= 1) 
        	{
		RadarPulse = RadarPulse - 1;
		}
}

defaultproperties
{
DrawTime=800
LogoColor=(R=255,G=0,B=0)
RadarColor=(R=126,G=126,B=126)
RadarScale=0.20
RadarPosX=0.05
RadarPosY=0.70
}

